/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWException;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRuleSetDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.workflow.VWBaseFieldTableModel;
import filenet.vw.toolkit.design.property.workflow.VWTableItemWrapper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;

public final class VWWorkflowRuleTableModel
extends VWBaseFieldTableModel {
    private static final int NUM_COLUMNS = 3;
    public static final int COL_SOURCE = 0;
    public static final int COL_NAME = 1;
    public static final int COL_EXPENSIVE = 2;
    private JComponent m_uiContainer = null;
    private int m_nAdditionalColumnCount = 1;

    public VWWorkflowRuleTableModel(VWAuthPropertyData authPropertyData, JComponent uiContainer) {
        super(authPropertyData);
        this.m_uiContainer = uiContainer;
        if (authPropertyData != null && authPropertyData.getAllowAsynchronousRules()) {
            this.m_nAdditionalColumnCount = 0;
        }
    }

    public void deleteItem(int nRowIndex) {
        block6: {
            try {
                VWRuleSetDefinition ruleSetDef;
                if (!this.canDeleteRow(nRowIndex)) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.canDelete() && (ruleSetDef = (VWRuleSetDefinition)wrapper.getValue()) != null) {
                    this.m_authPropertyData.getWorkflowDefinition().deleteRuleSet(ruleSetDef.getName());
                    this.m_authPropertyData.resetRuleSetCache();
                    this.m_authPropertyData.setDirty();
                    if (wrapper.isOverridden()) {
                        wrapper.deleteOverriddenValue();
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    } else {
                        this.m_rowData.removeElementAt(nRowIndex);
                        this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(ruleSetDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 544);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void reinitialize() {
        try {
            super.reinitialize();
            if (this.m_authPropertyData != null) {
                int i;
                VWRuleSetDefinition[] ruleSetDefs;
                if (this.m_authPropertyData.getShowInheritedProperties() && (ruleSetDefs = this.m_authPropertyData.getRuleSets(2)) != null) {
                    for (i = 0; i < ruleSetDefs.length; ++i) {
                        this.m_rowData.addElement(new VWTableItemWrapper(1, ruleSetDefs[i]));
                    }
                }
                if ((ruleSetDefs = this.m_authPropertyData.getRuleSets(1)) != null) {
                    for (i = 0; i < ruleSetDefs.length; ++i) {
                        int nIndex = this.findIndex(ruleSetDefs[i].getName());
                        if (nIndex != -1) {
                            this.overrideTableItem(nIndex, ruleSetDefs[i]);
                            continue;
                        }
                        this.m_rowData.addElement(new VWTableItemWrapper(0, ruleSetDefs[i]));
                    }
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int findIndex(String fieldName) {
        int nRowIndex = -1;
        int size = this.m_rowData.size();
        if (size > 0 && fieldName != null && fieldName.length() > 0) {
            for (int i = 0; i < size; ++i) {
                String name;
                VWRuleSetDefinition ruleSetDef;
                VWTableItemWrapper wrapper = this.getTableItemAt(i);
                if (wrapper == null || wrapper.getValue() == null || (ruleSetDef = (VWRuleSetDefinition)wrapper.getValue()) == null || VWStringUtils.compare(fieldName, name = ruleSetDef.getName()) != 0) continue;
                nRowIndex = i;
                break;
            }
        }
        return nRowIndex;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 0: {
                return Icon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3 - this.m_nColumnIndexOffset - this.m_nAdditionalColumnCount;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                return VWResource.s_name;
            }
        }
        return null;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 0: {
                if (wrapper == null) break;
                return wrapper.getStateIcon();
            }
            case 1: {
                if (wrapper == null) break;
                return (VWRuleSetDefinition)wrapper.getValue();
            }
            case 2: {
                VWRuleSetDefinition ruleSetDef;
                if (wrapper != null && (ruleSetDef = (VWRuleSetDefinition)wrapper.getValue()) != null) {
                    try {
                        return new Boolean(ruleSetDef.getExpensive());
                    }
                    catch (VWException ex) {
                        VWDebug.logException(ex);
                    }
                }
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    return wrapper.isLocal();
                }
                return true;
            }
            case 2: {
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper == null) break;
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                this.onUpdateName(aValue, nRowIndex);
                break;
            }
            case 2: {
                this.onUpdateExpense(aValue, nRowIndex);
            }
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        block9: {
            try {
                if (aValue == null || !(aValue instanceof String)) {
                    return;
                }
                String newRuleSetName = (String)aValue;
                if (newRuleSetName.length() == 0) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    VWRuleSetDefinition ruleSetDef;
                    if (wrapper.isLocal() && (ruleSetDef = (VWRuleSetDefinition)wrapper.getValue()) != null) {
                        if (VWStringUtils.compare(newRuleSetName, ruleSetDef.getName()) == 0) {
                            return;
                        }
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(ruleSetDef.getName());
                        this.m_changedItems.addElement(newRuleSetName);
                        ruleSetDef.setName(newRuleSetName);
                        this.m_authPropertyData.setDirty();
                        this.handleRuleRename(this.m_changedItems);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 543);
                    }
                } else {
                    if (this.m_authPropertyData.getRuleSet(newRuleSetName) != null) {
                        String message = VWResource.s_ruleSetExists.toString(newRuleSetName);
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), message, 1);
                        return;
                    }
                    VWRuleSetDefinition newRuleSetDef = this.m_authPropertyData.getWorkflowDefinition().createRuleSet(newRuleSetName);
                    this.m_rowData.addElement(new VWTableItemWrapper(0, newRuleSetDef));
                    nRowIndex = this.m_rowData.size() - 1;
                    this.m_authPropertyData.resetRuleSetCache();
                    this.m_authPropertyData.setDirty();
                    this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(newRuleSetDef);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 541);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block9;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRuleRename(Vector params) {
        if (params != null && params.size() >= 2) {
            String oldName = (String)params.elementAt(0);
            String newName = (String)params.elementAt(1);
            if (oldName != null && oldName.length() > 0 && newName != null && newName.length() > 0) {
                this.m_authPropertyData.displayWaitCursor(this.m_uiContainer);
                try {
                    try {
                        VWMapDefinition[] mapDefs = this.m_authPropertyData.getWorkflowDefinition().getMaps();
                        for (int i = 0; i < mapDefs.length; ++i) {
                            VWMapNode[] mapNodes = mapDefs[i].getSteps();
                            if (mapNodes == null) continue;
                            for (int j = 0; j < mapNodes.length; ++j) {
                                this.findAndReplaceRuleSet(mapNodes[j], oldName, newName, 0);
                                this.findAndReplaceRuleSet(mapNodes[j], oldName, newName, 1);
                                this.findAndReplaceRuleSet(mapNodes[j], oldName, newName, 2);
                            }
                        }
                        Object var9_9 = null;
                        this.m_authPropertyData.restoreDefaultCursor(this.m_uiContainer);
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var9_10 = null;
                        this.m_authPropertyData.restoreDefaultCursor(this.m_uiContainer);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    this.m_authPropertyData.restoreDefaultCursor(this.m_uiContainer);
                    throw throwable;
                }
            }
        }
    }

    private void findAndReplaceRuleSet(VWMapNode mapNode, String oldName, String newName, int nType) {
        block3: {
            try {
                String[] selectedRuleSetNames;
                if (mapNode == null || oldName == null || newName == null || (selectedRuleSetNames = mapNode.getRuleSetNames(nType)) == null) break block3;
                for (int i = 0; i < selectedRuleSetNames.length; ++i) {
                    if (VWStringUtils.compare(oldName, selectedRuleSetNames[i]) != 0) continue;
                    selectedRuleSetNames[i] = newName;
                    mapNode.setRuleSets(nType, selectedRuleSetNames);
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateExpense(Object aValue, int nRowIndex) {
        block12: {
            block11: {
                try {
                    try {
                        block14: {
                            block13: {
                                if (aValue == null) break block13;
                                if (aValue instanceof Boolean) break block14;
                            }
                            Object var7_3 = null;
                            break block11;
                        }
                        Boolean bExpensive = (Boolean)aValue;
                        VWRuleSetDefinition ruleSetDef = null;
                        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                        if (wrapper != null && wrapper.getValue() != null) {
                            ruleSetDef = (VWRuleSetDefinition)wrapper.getValue();
                        }
                        if (ruleSetDef != null) {
                            if (wrapper.isInherited()) {
                                ruleSetDef = this.m_authPropertyData.getWorkflowDefinition().createRuleSet(ruleSetDef.getName());
                                ruleSetDef.setExpensive(bExpensive);
                                wrapper.overrideValue(ruleSetDef);
                            } else {
                                ruleSetDef.setExpensive(bExpensive);
                            }
                            this.m_authPropertyData.setDirty();
                        }
                        break block12;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        if (this.m_authPropertyData != null) {
                            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                        }
                        Object var7_5 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    throw throwable;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var7_4 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }
}

